package w83b.w83bUtilidadesLibroRegistro;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;

import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bLibroRegistro.
 *
 * @author Deusto Sistemas
 */
public class W83bLibroRegistro {
	
	/**
	 * Gets the libro registro url.
	 *
	 * @return the libro registro url
	 * @throws Exception the exception
	 */
	private static String getLibroRegistroUrl() throws Exception {
		return Q70ListenerUtils.getApplicationProperty("LIBRO_REGISTRO_URL");
	}
	
	/**
	 * Gets the libro registro hora url.
	 *
	 * @return the libro registro hora url
	 * @throws Exception the exception
	 */
	private static String getLibroRegistroHoraUrl() throws Exception {
		return Q70ListenerUtils.getApplicationProperty("LIBRO_REGISTRO_HORA_URL");
	}
	
	/**
	 * Gets the libro registro modelo salida.
	 *
	 * @return the libro registro modelo salida
	 * @throws Exception the exception
	 */
	public static String getLibroRegistroModeloSalida() throws Exception {
		return Q70ListenerUtils.getApplicationProperty("MODELO_SALIDA");
	}
	
	/**
	 * Gets the libro registro modelo entrada.
	 *
	 * @return the libro registro modelo entrada
	 * @throws Exception the exception
	 */
	public String getLibroRegistroModeloEntrada() throws Exception {
		return Q70ListenerUtils.getApplicationProperty("MODELO_ENTRADA");
	}
	
	/**
	 * Gets the app code.
	 *
	 * @return the app code
	 * @throws Exception the exception
	 */
	private static String getAppCode() throws Exception {
		return Q70ListenerUtils.getApplicationProperty("APPLICATION_CODE");
	}
	
	/**
	 * Gets the alta registro.
	 *
	 * @param hora the hora
	 * @param modelo the modelo
	 * @param sentido the sentido
	 * @param entorno the entorno
	 * @param empresa the empresa
	 * @param poblacion the poblacion
	 * @param unidadOrganica the unidad organica
	 * @param observaciones the observaciones
	 * @return the alta registro [0] -> n Registro
	 * 							 [1] -> fecha Registro
	 * @throws Exception the exception
	 */
	public static String[] getAltaRegistro(boolean hora, String modelo, String sentido, String entorno,
			String empresa, String poblacion, String unidadOrganica, String observaciones,
			W83bUsuarioXLNetsBean userBean) throws Exception {
	
		String[] registro = new String[2];
	    registro[0] = null;
	    registro[1] = null;
	    
		if (Q70ListenerUtils.getApplicationProperty("catalogo.ACTIVE").equals("true")){
			
			String host = getLibroRegistroUrl();
			if (hora){
				host = getLibroRegistroHoraUrl();
			}
			String datos = "modelo=" + URLEncoder.encode(modelo, "ISO-8859-1");//NOPMD
			URLDecoder.decode(modelo, "ISO-8859-1");
			datos +="&sentidoLibro="+sentido;//NOPMD
			datos +="&entornoLibro="+entorno;//NOPMD
		    if (empresa!=null && !W83bClsConstantes.VACIO.equals(empresa.trim())){
		    	datos +="&nombreEmpresa="+empresa.trim();//NOPMD
		    }
		    if (poblacion!=null && !W83bClsConstantes.VACIO.equals(poblacion.trim())){
		    	datos +="&poblacionInterlocutor="+poblacion.trim();//NOPMD
		    }
		    if (unidadOrganica!=null && !W83bClsConstantes.VACIO.equals(unidadOrganica.trim())){
		    	datos +="&uo=" + URLEncoder.encode(unidadOrganica, "ISO-8859-1");//NOPMD
		    }
		    if (observaciones!=null && !W83bClsConstantes.VACIO.equals(observaciones.trim())){
		    	datos +="&observaciones=" + URLEncoder.encode(observaciones, "ISO-8859-1");//NOPMD
		    }
		    String temp = getAppCode();
		    if(temp!=null && !W83bClsConstantes.VACIO.equals(temp.trim())){
		    	datos +="&aplic=" + URLEncoder.encode(getAppCode(), "ISO-8859-1");//NOPMD
		    }
		    W83bClsTrazas.trazaError(null,"LIBROREGISTRO - URL\n"+datos,null);
		    
		    StringBuffer contenido = new StringBuffer(W83bClsConstantes.VACIO);
		
		      try {
		        if (datos != null) {
		          // Conexin URL a AltaReg
		          URL url = new URL(host);
		          
		
		          //URLConnection yc = url.openConnection();
		          HttpURLConnection conn = (HttpURLConnection)url.openConnection();
		          if (conn != null) {
		            conn.setDoInput(true);
		            conn.setDoOutput(true);
		            conn.setUseCaches(false);
		
		            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
		            conn.setRequestProperty("Connection", "keep-alive");
		            conn.setRequestProperty("Content-Length", "" + Integer.toString(datos.getBytes().length));
		            conn.setRequestMethod("POST");
		            PrintWriter out = new PrintWriter(conn.getOutputStream());
		            out.print(datos);
		            out.close();
		
		            // Se lee la respuesta del servidor
		            InputStream is = conn.getInputStream();
		            if (is != null) {
		              InputStreamReader isr = new InputStreamReader(is);
		              if (isr != null) {
		                BufferedReader in = new BufferedReader(isr);
		                String inputLine;
		                while ((inputLine = in.readLine()) != null) {
		                  contenido.append(inputLine);
		                }
		                in.close();
		                String cadenaRegistro = contenido.toString();
		                W83bClsTrazas.trazaError(null,"LIBROREGISTRO - RTO\n "+cadenaRegistro,null);
		                String numeroRegistro = cadenaRegistro.substring(0, cadenaRegistro.indexOf("@"));
		                String fechaRegistro = cadenaRegistro.substring(cadenaRegistro.indexOf("@") + 1,
		                    cadenaRegistro.lastIndexOf("@"));
		                	Date fechaRegistroDate;
		                  registro[0] = numeroRegistro;
		                  if (hora){
		                	  fechaRegistroDate = W83bDateUtil.getInstance().getDate(fechaRegistro, "dd/MM/yy HH:mm:ss");
		                	  fechaRegistro = W83bDateUtil.getInstance().getLocaleStringFromDateHora(fechaRegistroDate,W83bClsConstantes.CONSTANTE_CASTELLANO);
		                  }
		                  else{
		                	  fechaRegistroDate = W83bDateUtil.getInstance().getDate(fechaRegistro, "dd/MM/yy");
		                	  fechaRegistro = W83bDateUtil.getInstance().getLocaleStringFromDate(fechaRegistroDate,W83bClsConstantes.CONSTANTE_CASTELLANO);
		                  }
		                  registro[1] = fechaRegistro;
		              }
		            }
		          }
		        } // end if (datos != null)
		      }
		      catch (Exception e) {
		    	  W83bClsTrazas.traza(null,"FALLO EN EL LIBRO DE REGISTRO "+e.getLocalizedMessage());
//		    	  e.printStackTrace();
		    	  W83bClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		    	  W83bClsTrazas.trazaError(null,contenido.toString(),e);
		        registro[0] = null;
		        registro[1] = null;
		        throw new W83bLibroRegistroException();
		      }
		}else{
			registro[0] = "2010RTE00040758";
			 //if (hora){
           	  registro[1] = "07/06/2010 22:10:11";					
             //}else{
           	  //registro[1] = "07/06/2010";					
            // }
		}
		
		W83bClsTrazas.traza(userBean,"n registro "+registro[0]);
		W83bClsTrazas.traza(userBean,"fecha registro "+registro[1]);
		
		//if(1==1){throw new W83bLibroRegistroException();}
        
	  return registro;
	}

	/** The instance. */
	private static W83bLibroRegistro instance = null;
	
	/**
	 * Gets the single instance of W83bLibroRegistro.
	 *
	 * @return single instance of W83bLibroRegistro
	 */
	public static W83bLibroRegistro getInstance(){
		if(instance==null){
			instance = new W83bLibroRegistro();
		}
		return instance;
	}
}
